/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.tracing;

import java.awt.AWTEvent;
import java.awt.event.InvocationEvent;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class TracingEventQueueThreadJMX
extends Thread {
    private long thresholdDelay;
    private long initTime = System.currentTimeMillis();
    private Map<AWTEvent, Long> eventTimeMap;
    private ThreadMXBean threadBean;

    public TracingEventQueueThreadJMX(long thresholdDelay) {
        this.thresholdDelay = thresholdDelay;
        this.eventTimeMap = new HashMap<AWTEvent, Long>();
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objName = new ObjectName("java.lang:type=Threading");
            Set<ObjectName> mbeans = mbeanServer.queryNames(objName, null);
            for (ObjectName name : mbeans) {
                this.threadBean = ManagementFactory.newPlatformMXBeanProxy(mbeanServer, name.toString(), ThreadMXBean.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void eventDispatched(AWTEvent event) {
        this.eventTimeMap.put(event, System.currentTimeMillis());
    }

    public synchronized void eventProcessed(AWTEvent event) {
        this.checkEventTime(event, System.currentTimeMillis(), this.eventTimeMap.get(event), "B");
        this.eventTimeMap.put(event, null);
    }

    private void checkEventTime(AWTEvent event, long currTime, long startTime, String callSite) {
        if (callSite.equals("A")) {
            return;
        }
        long currProcessingTime = currTime - startTime;
        if (currProcessingTime >= this.thresholdDelay) {
            long deltaTime = currTime - this.initTime;
            String msg = " is taking too much time on EDT (";
            if (callSite.equals("B")) {
                msg = " took too much time on EDT (";
            }
            System.err.println(String.format("@%8.1fs: ", (double)deltaTime / 1000.0) + "Event [" + event.hashCode() + "] " + event.getClass().getName() + msg + currProcessingTime + " ms)");
            if (event instanceof InvocationEvent) {
                System.err.println("InvocationEvent.paramString: " + ((InvocationEvent)event).paramString());
            }
            boolean verbose = true;
            if (this.threadBean != null) {
                long[] threadIds;
                block0: for (long threadId : threadIds = this.threadBean.getAllThreadIds()) {
                    StackTraceElement[] stack;
                    ThreadInfo threadInfo = this.threadBean.getThreadInfo(threadId, Integer.MAX_VALUE);
                    if (!threadInfo.getThreadName().startsWith("AWT-EventQueue")) continue;
                    if (verbose) {
                        System.err.println(threadInfo.getThreadName() + " / " + (Object)((Object)threadInfo.getThreadState()));
                    }
                    for (StackTraceElement stackEntry : stack = threadInfo.getStackTrace()) {
                        if (verbose) {
                            System.err.println("\t" + stackEntry.getClassName() + "." + stackEntry.getMethodName() + " [" + stackEntry.getLineNumber() + "]");
                            continue;
                        }
                        if (!stackEntry.getClassName().contains("autoplot") && !stackEntry.getClassName().contains("das2")) continue;
                        System.err.println("\t" + stackEntry.getClassName() + "." + stackEntry.getMethodName() + " [" + stackEntry.getLineNumber() + "]");
                        continue block0;
                    }
                }
                long[] deadlockedThreads = this.threadBean.findDeadlockedThreads();
                if (deadlockedThreads != null && deadlockedThreads.length > 0) {
                    System.err.println("Deadlocked threads:");
                    for (long threadId : deadlockedThreads) {
                        StackTraceElement[] stack;
                        ThreadInfo threadInfo = this.threadBean.getThreadInfo(threadId, Integer.MAX_VALUE);
                        System.err.println(threadInfo.getThreadName() + " / " + (Object)((Object)threadInfo.getThreadState()));
                        for (StackTraceElement stackEntry : stack = threadInfo.getStackTrace()) {
                            System.err.println("\t" + stackEntry.getClassName() + "." + stackEntry.getMethodName() + " [" + stackEntry.getLineNumber() + "]");
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            long currTime = System.currentTimeMillis();
            TracingEventQueueThreadJMX tracingEventQueueThreadJMX = this;
            synchronized (tracingEventQueueThreadJMX) {
                for (Map.Entry<AWTEvent, Long> entry : this.eventTimeMap.entrySet()) {
                    AWTEvent event = entry.getKey();
                    if (entry.getValue() == null) continue;
                    long startTime = entry.getValue();
                    this.checkEventTime(event, currTime, startTime, "A");
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

